<?php
    include('authentication.php');
    include('config/dbcon.php');

    include('includes/header.php');
    include('includes/topbar.php');
    include('includes/sidebar.php');
?>


<!-- Modal -->
<div class="modal fade" id="CategoryModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5" id="exampleModalLabel">Gift Category</h5>
        <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
      </div>

      <form action="category_code.php" method="POST">
            <div class="modal-body">
                <div class="form group">
                    <label for="">Category Name</label>
                    <input type="text" name="name" class="form-control" required>
                </div>
                <div class="form group">
                    <label for="">Description</label>
                    <textarea name="description" class="form-control" required rows="3"></textarea>
                </div>
                <div class="form group">
                    <label for="">Trending</label>
                    <input type="checkbox" name="trending">Trending
                </div>
                <div class="form group">
                    <label for="">Status</label>
                    <input type="checkbox" name="status">Status
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" name="category_save" class="btn btn-primary">Save</button>
            </div>
     </form>

    </div>
  </div>
</div>

 <!-- Content Wrapper. Contains page content -->
 <div class="content-wrapper">

<?php
    if(isset($_GET['prod_id']))
    {
        $product_id=$_GET['prod_id'];
        $query="SELECT * FROM products where id='$product_id'";
        $query_run=mysqli_query($con,$query);

        if(mysqli_num_rows($query_run)>0)
        {
            
            $proditem=mysqli_fetch_array($query_run);
            // $categoryid=$proditem['categoryid'];
            ?>
             
        <section class="content mt-4">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <?php include("message.php"); ?>
                        <div class="card">
                            <div class="card-header">
                                <h4>
                                    Products - Edit
                                    <a href="product.php" class="btn btn-danger float-right">Back</a>
                                </h4>
                            </div>
                            <div class="card-body">  

                                <form action="product_code.php" method="POST" enctype="multipart/form-data">
                                    <input type="hidden" name="product_id" value="<?= $proditem['id'] ?>">
                                    

                                    <div class="row">

                                        <!-- Start load all categories -->
                                        <div class="col-md-12">
                                        <label>Select Category</label>
                                            <?php
                                                $query="SELECT * FROM categories";
                                                $query_run=mysqli_query($con,$query);

                                              

                                                if(mysqli_num_rows($query_run) > 0)
                                                {
                                                        ?>

                                                            <select name="categoryid" required class="form-control" >
                                                                <option value="">Select Category</option>
                                                                <?php foreach($query_run as $item){ ?>
                                                                    
                                                                    <option value="<?= $item['id'] ?>"> <?= $proditem['categoryid']  ==  $item['id'] ? 'selected' : '' ?>
                                                                        <?= $item['name'] ?>
                                                                    </option>
                                                                   
                                                                <?php } ?>
                                                                
                                                            </select>
                                                        <?php                              

                                                }
                                            ?>
                                        </div>
                                         <!-- End load all categories -->

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Product Name</label>
                                                <input type="text" name="name" value="<?= $proditem['name'] ?>" class="form-control" placeholder="Enter Product name">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Small Description</label>
                                                <textarea name="small_description" class="form-control" required rows ="3" placeholder="Enter Small description"><?= $proditem['small_description'] ?></textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Long Description</label>
                                                <textarea name="long_description" name="name" class="form-control" required rows ="3" placeholder="Enter Long description"><?= $proditem['long_description'] ?></textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Price</label>
                                                <input type="text" name="price" value="<?= $proditem['price'] ?>" class="form-control" required placeholder="Enter Price">
                                            </div>
                                        </div> 
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Offer Price</label>
                                                <input type="text" name="offerprice" value="<?= $proditem['offerprice'] ?>" class="form-control" placeholder="Enter Offer Price">
                                            </div>
                                        </div> 
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Tax</label>
                                                <input type="text" name="tax" value="<?= $proditem['tax'] ?>" class="form-control" placeholder="Enter Tax">
                                            </div>
                                        </div> 
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Quantity</label>
                                                <input type="text" name="quantity" value="<?= $proditem['quantity'] ?>" class="form-control" placeholder="Enter Quantity">
                                            </div>
                                        </div> 
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Status (Checked = Show | Hide)</label><br>
                                                <input type="checkbox" name="status" <?= $proditem['status'] == '1' ? 'checked':''?> >Show/Hide
                                            </div>
                                        </div> 
                                        <div class="col-md-8">
                                            <div class="form-group">
                                                <label>Upload Image</label>
                                                <input type="file" name="image" class="form-control">
                                                <input type="hidden" name="old_image" value="<?= $proditem['image'] ?>">
                                            </div>
                                            <img src="uploads/product/<?= $proditem['image'] ?>" width="50px" height="50px" alt="image">
                                        </div> 
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <button type="submit" name="product_update" class="btn btn-primary">Update</Button>
                                            </div>
                                        </div> 
                                    </div>
                                </form>                       
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        
    </section>

    <?php
        }
        else
        {
            echo "No records found";
        }
    }
?>
</div>



<?php include('includes/script.php');?>
<?php include('includes/footer.php');?>