<?php
    include('authentication.php');
    include('config/dbcon.php');

    include('includes/header.php');
    include('includes/topbar.php');
    include('includes/sidebar.php');
?>


<!-- Modal -->
<div class="modal fade" id="orderDetailsModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5" id="exampleModalLabel">Order Details</h5>
        <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
      </div>

      <form action="category_code.php" method="POST">
            <div class="modal-body">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>Item Name</th>
                            <th>Item Size</th>
                            <th>Item Grade</th>
                            <th>Item Quantity</th> 
                       </tr>
                    </thead>
                    <tbody id="orderDetailsTbody">
                        
                     </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
     </form>

    </div>
  </div>
</div>

 <!-- Content Wrapper. Contains page content -->
 <div class="content-wrapper">

    <section class="content mt-4">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <?php include("message.php"); ?>
                    <div class="card">
                        <div class="card-header">
                            <h4>
                                Orders
                                <a href="add_order.php" class="btn btn-primary float-right">Add</a>
                            </h4>
                        </div>
                        <div class="card-body">
                            <!--<table class="table table-bordered"> -->
                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Order Date</th>
                                        <th>Customer Name</th>
                                        <th>Qty</th>
                                        <th>Status</th>
                                        <th>ID</th>
                                        <th>Details</th>
                                        <th>Edit</th>
                                        <th>Delete</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        $query="SELECT ordermaster.*, ledgermaster.LedgerName FROM ordermaster INNER JOIN ledgermaster ON ordermaster.LedgerID=ledgermaster.LedgerID;
                                        ";
                                        $query_run=mysqli_query($con,$query);

                                        if (mysqli_num_rows($query_run)>0)
                                        {
                                            foreach($query_run as $order_item)
                                            {
                                                //echo ;
                                                ?>
                                                    <tr>
                                                        <td><?= $order_item['OrderDate']; ?></td>
                                                       <td><?= $order_item['LedgerName']; ?></td>
                                                        <td><?= $order_item['TotalOrderQty']; ?></td>
                                                        <td><?= $order_item['Status']; ?></td>
                                                        <td><?= $order_item['OrderNo']; ?></td>
                                                        <td>
                                                            <a href="#" class="btn btn-info btn-sm details-button"
                                                            data-toggle="modal" data-target="#orderDetailsModal" data-order-id="<?= $order_item['OrderID']; ?>"
                                                            >Details</a>
                                                        </td>
                                                        <td>
                                                            <a href="order_edit.php?ord_id=<?= $order_item['OrderID']; ?>" class="btn btn-info btn-sm">Edit</a>
                                                        </td>
                                                        <td>
                                                         

                                                            <form action="order_code.php" method="POST">
                                                                <input type="hidden" name="ord_delete_id" value="<?= $order_item['OrderID']; ?>">
                                                                <button type="submit" name="ord_delete_btn" Class="btn btn-danger btn-sm"> Delete </button>
                                                            </form>
                                                        </td>
                                                        
                                                    </tr>
                                                <?php
                                            }

                                        }
                                        else
                                        {
                                            ?>

                                                <tr>
                                                    <td colspan="6">No Record Found</td>
                                                </tr>

                                            <?php
                                        }
                                    ?>
                                    
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


</div>



<?php include('includes/script.php');?>
<?php include('includes/footer.php');?>
<script type="text/javascript" src="assets/dist/js/pages/add_order.js"></script>
