<?php

include('authentication.php');
include('config/dbcon.php');

include('includes/header.php');
include('includes/topbar.php');
include('includes/sidebar.php');


if (isset($_GET['id'])) {
    $material_id = $_GET['id'];
 
    

    // Fetch material_id from materials table
    $query1 = "SELECT * FROM materials WHERE material_id = '$material_id'";
    $query1_run = mysqli_query($con, $query1);
    $mat = mysqli_fetch_assoc($query1_run);

   

    // Fetch Item Details from materials_dtls
    $query2 = "SELECT * FROM materials_dtls WHERE material_id = '$material_id'";
    $query2_run = mysqli_query($con, $query2);
    $items = mysqli_fetch_all($query2_run, MYSQLI_ASSOC);

   

}
// update code 

if (isset($_POST['update_inward'])) {
   
    $voucher_no = $_POST['voucher_no'];
    $voucher_date = date('Y-m-d', strtotime($_POST['voucher_date']));
    $ledger_id = $_POST['ledger_id'];
    $ref_no = $_POST['ref_no'];
    $ref_date = date('Y-m-d', strtotime($_POST['ref_date']));
    $vehicle_id = $_POST['vehicle_id'];
    $remark = $_POST['remark'];
    $total_qty = $_POST['total_qty'];
    $voucher_type = 'Inward';
    $company_id = 1;
    $is_deleted = 0;
    $add_user_id = 1;
    $add_user_date = date('Y-m-d', strtotime($_POST['adduser_date']));

    // Update materials
    $update1 = "UPDATE materials SET voucher_no='$voucher_no', voucher_date='$voucher_date', ledger_id='$ledger_id', remark='$remark', ref_no='$ref_no', ref_date='$ref_date', vehicle_id='$vehicle_id', 
                total_qty='$total_qty', company_id='$company_id', isdeleted='$is_deleted', adduser_id='$add_user_id', adduser_date='$add_user_date' 
                WHERE material_id='$material_id'";
    mysqli_query($con, $update1);



     // Delete old item details
     mysqli_query($con, "DELETE FROM materials_dtls WHERE material_id='$material_id'");

   // Insert updated items
   foreach ($_POST['group_id'] as $index => $group_id) {
    $item_id = $_POST['item_id'][$index];
    $qty = (float)$_POST['qty'][$index];

    $unit_id = (int)$_POST['unit_id'][$index];
    $query2 = "INSERT INTO materials_dtls (material_id, group_id, item_id, qty, unit_id, company_id, isdeleted, adduser_id, adduser_date) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt2 = mysqli_prepare($con, $query2);
    mysqli_stmt_bind_param($stmt2, 'iiiiiiiis', $material_id, $group_id, $item_id, $qty, $unit_id, $company_id, $is_deleted, $add_user_id, $add_user_date);
    mysqli_stmt_execute($stmt2);
}


echo "<script>alert('Inward updated successfully');</script>";
echo "<script>window.open('inward.php', '_self');</script>";
exit;
   
}

// update code end

?>

<div class="content-wrapper">
    <section class="content mt-4">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <?php include("message.php"); ?>
                    <div class="card">
                        <div class="card-header">
                            <h4>
                                Edit Inward
                                <a href="inward.php" class="btn btn-danger float-right">Back</a>
                            </h4>
                        </div>
                        <div class="card-body">
                            <form action="" method="POST">
                                <!-- Sale Details -->
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Voucher No</label>
                                            <input type="text" name="voucher_no" class="form-control" value="<?= $mat['voucher_no'] ?>" readonly>
                                        </div>
                                    </div>
                                     
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Voucher Date</label>
                                            <input type="date" name="voucher_date" class="form-control" value="<?= date('Y-m-d', strtotime($mat['voucher_date'])) ?>">
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Ledger Name</label>
                                            <select name="ledger_id" class="form-control" required>
                                                <option value="">Select Ledger</option>
                                                <?php
                                                $query = "SELECT * FROM ledgermaster";
                                                $query_run = mysqli_query($con, $query);
                                                foreach ($query_run as $ledger) {
                                                    $selected = ($mat['ledger_id'] == $ledger['LedgerID']) ? 'selected' : '';
                                                    echo "<option value='{$ledger['LedgerID']}' $selected>{$ledger['LedgerName']}</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-md-6">
                                            <label for="ref_no" class="form-label">Voucher Ref.No:</label>
                                            <input type="number" class="form-control" id="ref_no" name="ref_no"  value="<?= $mat['ref_no'] ?>">
                                        </div>
                                        <div class="col-md-6">
                                            <label for="ref_date" class="form-label">Voucher Date:</label>
                                            <input type="date" name="ref_date" class="form-control" value="<?= date('Y-m-d', strtotime($mat['ref_date'])) ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Vehicle No</label>
                                            <select name="vehicle_id" class="form-control" required>
                                                <option value="">Select Vehicle</option>
                                                <?php
                                                $query = "SELECT * FROM vehicles";
                                                $query_run = mysqli_query($con, $query);
                                                foreach ($query_run as $veh) {
                                                    $selected = ($mat['vehicle_id'] == $veh['vehicle_id']) ? 'selected' : '';
                                                    echo "<option value='{$veh['vehicle_id']}' $selected>{$veh['vehicle_name']}</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>

                                </div>

                                <!-- Item Details -->
                                <h5>Item Details</h5>
                                <div class="table-responsive">
                                    <table class="table table-bordered" id="item_table">
                                        <thead>
                                            <tr>
                                                <th>Group Name</th>
                                                <th>Item Name</th>
                                                <th>Qty</th>
                                                <th>Unit</th>
                                               
                                                <th><button type="button" id="addRow" class="btn btn-success btn-sm">+</button></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($items as $item): ?>
                                            <tr>
                                                <!-- Group Name -->
                                                <td>
                                                    <select name="group_id[]" class="form-control group-select" required onchange="loadItems(this)">
                                                        <option value="">Select Group</option>
                                                        <?php
                                                        $query = "SELECT * FROM itemgroupmaster";
                                                        $query_run = mysqli_query($con, $query);
                                                        foreach ($query_run as $grp) {
                                                            $selected = ($item['ItemGroupID'] == $grp['ItemGroupID']) ? 'selected' : '';
                                                          
                                                            echo "<option value='{$grp['ItemGroupID']}' $selected>{$grp['ItemGroupName']}</option>";
                                                        }
                                                        ?>
                                                    </select>
                                                </td>
                                                <!-- Item Name -->
                                                <td>
                                                    <select name="item_id[]" class="form-control item-select" required>
                                                        <option value="">Select Item</option>
                                                        <?php
                                                        $query = "SELECT * FROM itemmaster";
                                                        $query_run = mysqli_query($con, $query);
                                                        foreach ($query_run as $it) {
                                                            $selected = ($item['ItemID'] == $it['ItemID']) ? 'selected' : '';
                                                            echo "<option value='{$it['ItemID']}' $selected>{$it['ItemName']}</option>";
                                                        }
                                                        ?>
                                                    </select>
                                                </td>
                                                <!-- Qty -->
                                                <td><input type="number" name="qty[]" class="form-control qty" value="<?= $item['qty'] ?>" required oninput="updateQtySum()"></td>
                                                <!-- Unit Name -->
                                                <td>
                                                    <select name="unit_id[]" class="form-control unit-select" required>
                                                        <option value="">Select Unit</option>
                                                        <?php
                                                        $query = "SELECT * FROM unitmaster";
                                                        $query_run = mysqli_query($con, $query);
                                                        foreach ($query_run as $ut) {
                                                            $selected = ($item['UnitID'] == $ut['UnitID']) ? 'selected' : '';
                                                            echo "<option value='{$ut['UnitID']}' $selected>{$ut['UnitName']}</option>";
                                                        }
                                                        ?>
                                                    </select>
                                                </td>
                                               
                                                
                                                <td><button type="button" class="btn btn-danger btn-sm removeRow">-</button></td>
                                            </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>

                                <!-- Summary Section -->
                                <div class="row mt-4">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Remark</label>
                                            <textarea name="remark" class="form-control" rows="3"><?= $mat['remark'] ?></textarea>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="table-responsive">
                                            <table class="table table-bordered">
                                                <!-- <tr>
                                                    <th>Total Basic Amt</th>
                                                    <td><input type="text" name="total_basic" id="total_basic" class="form-control" value="<?= $sale['SubTotal'] ?>" readonly></td>
                                                </tr>
                                                <tr>
                                                    <th>Total Taxable Amt</th>
                                                    <td><input type="text" name="total_taxable" id="total_taxable" class="form-control" value="<?= $sale['TotalTaxableAmt'] ?>" readonly></td>
                                                </tr>
                                                <tr>
                                                    <th>Other Charges</th>
                                                    <td><input type="number" name="other_charges" id="other_charges" class="form-control" value="<?= $sale['OtherCharges'] ?>"></td>
                                                </tr> -->
                                                <tr>
                                                    <th>Total Qty</th>
                                                    <td><input type="text" name="total_qty" id="total_qty" class="form-control" value="<?= $mat['total_qty'] ?>" readonly></td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <div class="modal-footer">
                                    <button type="submit" name="update_inward" class="btn btn-primary">Update</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
document.addEventListener('click', function (e) {
    if (e.target.id === 'addRow') {
        let table = document.getElementById('item_table').getElementsByTagName('tbody')[0];
        let newRow = table.rows[0].cloneNode(true);
        newRow.querySelectorAll('select, input').forEach(input => input.value = '');
        table.appendChild(newRow);
    } else if (e.target.classList.contains('removeRow')) {
        if (document.querySelectorAll('#item_table tbody tr').length > 1) {
            e.target.closest('tr').remove();
            updateQtySum();
        }
    }
});

function loadItems(select) {
    let groupId = select.value;
    let row = select.closest('tr');
    let itemSelect = row.querySelector('.item-select');

    if (groupId) {
        fetch(`get_items.php?group_id=${groupId}`)
            .then(response => response.json())
            .then(data => {
                itemSelect.innerHTML = '<option value="">Select Item</option>';
                data.forEach(item => {
                    itemSelect.innerHTML += `<option value="${item.ItemID}">${item.ItemName}</option>`;
                });
            });
    } else {
        itemSelect.innerHTML = '<option value="">Select Item</option>';
    }
}

function updateQtySum() {
    let totalQty = 0;
    document.querySelectorAll('.qty').forEach(input => {
        totalQty += parseFloat(input.value) || 0;
    });
    document.getElementById('total_qty').value = totalQty.toFixed(2);
}
</script>

<?php include('includes/footer.php'); ?>
