<?php

// Include authentication and database connection
include('authentication.php');
include('config/dbcon.php');


include('includes/header.php');
include('includes/topbar.php');
include('includes/sidebar.php');

// Check if 'id' parameter is passed via GET request
if (isset($_GET['id'])) {
    $material_id = $_GET['id'];

    // Prevent SQL injection by using prepared statements
    $stmt1 = $con->prepare("DELETE FROM materials WHERE material_id = ?");
    $stmt2 = $con->prepare("DELETE FROM materials_dtls WHERE material_id = ?");
   

    // Bind the parameter
    $stmt1->bind_param("i", $material_id);
    $stmt2->bind_param("i", $material_id);


    // Execute the queries and check if they were successful
    if ($stmt1->execute() && $stmt2->execute()) {
        echo "<script>alert('Record deleted successfully');</script>";
    } else {
        echo "<script>alert('Error deleting record');</script>";
    }

    // Redirect to sale.php after the deletion
    echo "<script>window.open('inward.php','_self');</script>";

    // Close the prepared statements
    $stmt1->close();
    $stmt2->close();
    
} else {
    // Handle case when id is not provided
    echo "<script>alert('No record selected for deletion');</script>";
    echo "<script>window.open('inward.php','_self');</script>";
}

?>
