<?php
include('authentication.php');
include('config/dbcon.php');

include('includes/header.php');
include('includes/topbar.php');
include('includes/sidebar.php');
?>

<div class="content-wrapper">
    <section class="content mt-4">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <?php include("message.php"); ?>
                    <div class="card">
                        <div class="card-header">
                            <h4>
                                Add Inward Entry
                                <a href="inward.php" class="btn btn-danger float-right">Back</a>
                            </h4>
                        </div>
                        <div class="card-body">
                            <form action="insert_inward.php" method="POST">
                                <!-- Sale Details -->
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Inward No</label>
                                            <?php
                                            $query = "SELECT MAX(voucher_no) AS MaxVoucherNo FROM materials";
                                            $result = mysqli_query($con, $query);
                                            $row = mysqli_fetch_assoc($result);
                                            $nextVoucherNo = $row['MaxVoucherNo'] + 1;
                                            ?>
                                            <input type="text" name="voucher_no" class="form-control" value="<?= $nextVoucherNo ?>" readonly>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Inward Date</label>
                                            <input type="date" name="voucher_date" class="form-control" value="<?= date('Y-m-d') ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Party Name</label>
                                            <select name="ledger_id" class="form-control" required>
                                                <option value="">Select Party</option>
                                                <?php
                                                $query = "SELECT * FROM ledgermaster";
                                                $query_run = mysqli_query($con, $query);
                                                foreach ($query_run as $ledger) {
                                                    echo "<option value='{$ledger['LedgerID']}'>{$ledger['LedgerName']}</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <div class="col-md-6">
                                            <label for="ref_no" class="form-label">Voucher Ref.No:</label>
                                            <input type="number" class="form-control" id="ref_no" name="ref_no">
                                        </div>
                                        <div class="col-md-6">
                                            <label for="ref_date" class="form-label">Voucher Date:</label>
                                            <input type="date" class="form-control" id="ref_date" name="ref_date" value="<?= date('Y-m-d'); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Vehicle No</label>
                                            <select name="vehicle_id" class="form-control" required>
                                                <option value="">Select Vehicle</option>
                                                <?php
                                                $query = "SELECT * FROM vehicles";
                                                $query_run = mysqli_query($con, $query);
                                                foreach ($query_run as $veh) {
                                                    echo "<option value='{$veh['vehicle_id']}'>{$veh['vehicle_name']}</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <!-- Item Details -->
                                <h5>Item Details</h5>
                                <div class="table-responsive">
                                    <table class="table table-bordered" id="item_table">
                                        <thead>
                                            <tr>
                                                <th>Group Name</th>
                                                <th>Item Name</th>
                                                <th>Qty</th>
                                                <th>Unit</th>
                                                <th><button type="button" id="addRow" class="btn btn-success btn-sm">+</button></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <select name="ItemGroupID[]" class="form-control group-select" required onchange="loadItems(this)">
                                                        <option value="">Select Group</option>
                                                        <?php
                                                        $query = "SELECT * FROM itemgroupmaster";
                                                        $query_run = mysqli_query($con, $query);
                                                        foreach ($query_run as $grp) {
                                                            echo "<option value='{$grp['ItemGroupID']}'>{$grp['ItemGroupName']}</option>";
                                                        }
                                                        ?>
                                                    </select>
                                                </td>
                                                <td>
                                                    <select name="item_id[]" class="form-control item-select" required>
                                                        <option value="">Select Item</option>
                                                    </select>
                                                </td>
                                                <td><input type="number" name="qty[]" class="form-control qty" min="1" required oninput="updateQtySum()"></td>
                                                <td>
                                                    <select name="unit_id[]" class="form-control unit-select" required>
                                                        <option value="">Select Unit</option>
                                                        <?php
                                                        $query = "SELECT * FROM unitmaster";
                                                        $query_run = mysqli_query($con, $query);
                                                        foreach ($query_run as $unit) {
                                                            echo "<option value='{$unit['UnitID']}'>{$unit['UnitName']}</option>";
                                                        }
                                                        ?>
                                                    </select>
                                                </td>
                                                <td><button type="button" class="btn btn-danger btn-sm removeRow">-</button></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                                <!-- Summary Section -->
                                <div class="row mt-4">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Remark</label>
                                            <textarea name="remark" class="form-control" rows="3" placeholder="Enter Remark"></textarea>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="table-responsive">
                                            <table class="table table-bordered">
                                                <tr>
                                                    <th>Total Qty</th>
                                                    <td><input type="text" name="total_qty" id="total_qty" class="form-control" readonly></td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <div class="modal-footer">
                                    <!-- <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button> -->
                                    <a href="inward.php" class="btn btn-secondary float-right">Close</a>
                                    <button type="submit" name="save_inward" class="btn btn-primary">Save</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
document.addEventListener('click', function (e) {
    if (e.target.id === 'addRow') {
        let table = document.getElementById('item_table').getElementsByTagName('tbody')[0];
        let newRow = table.rows[0].cloneNode(true);
        newRow.querySelectorAll('select, input').forEach(input => input.value = '');
        table.appendChild(newRow);
    } else if (e.target.classList.contains('removeRow')) {
        if (document.querySelectorAll('#item_table tbody tr').length > 1) {
            e.target.closest('tr').remove();
            updateQtySum();
        }
    }
});

// function loadItems(select) {
//     let ItemGroupID = select.value;
//     let row = select.closest('tr');
//     let itemSelect = row.querySelector('.item-select');

//     if (ItemGroupID) {
//         fetch(`get_items.php?ItemGroupID=${ItemGroupID}`)
//             .then(response => response.json())
//             .then(data => {
//                 itemSelect.innerHTML = '<option value="">Select Item</option>';
//                 data.forEach(item => {
//                     itemSelect.innerHTML += `<option value="${item.ItemID}">${item.ItemName}</option>`;
//                 });
//             });
//     } else {
//         itemSelect.innerHTML = '<option value="">Select Item</option>';
//     }
// }

function loadItems(select) {
    let ItemGroupID = select.value;
    let row = select.closest('tr');
    let itemSelect = row.querySelector('.item-select');

    if (ItemGroupID) {
        fetch(`get_items.php?ItemGroupID=${ItemGroupID}`)
            .then(response => {
                if (!response.ok) {
                    throw new Error(`HTTP error! status: ${response.status}`);
                }
                return response.json();
            })
            .then(data => {
                itemSelect.innerHTML = '<option value="">Select Item</option>';
                data.forEach(item => {
                    itemSelect.innerHTML += `<option value="${item.ItemID}">${item.ItemName}</option>`;
                });
            })
            .catch(error => {
                console.error('Error loading items:', error);
                alert('Failed to load items. Please try again.');
            });
    } else {
        itemSelect.innerHTML = '<option value="">Select Item</option>';
    }
}


function updateQtySum() {
    let totalQty = 0;
    document.querySelectorAll('.qty').forEach(input => {
        totalQty += parseFloat(input.value) || 0;
    });
    document.getElementById('total_qty').value = totalQty.toFixed(2);
}
</script>

<?php include('includes/footer.php'); ?>
