<?php
    include('authentication.php');
    include('config/dbcon.php');

    include('includes/header.php');
    include('includes/topbar.php');
    include('includes/sidebar.php');
?>


<!-- Modal -->
<div class="modal fade" id="InwardModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5" id="exampleModalLabel">Item Details</h5>
        <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
      </div>


    </div>
  </div>
</div>

 <!-- Content Wrapper. Contains page content -->
 <div class="content-wrapper">

    <section class="content mt-4">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <?php include("message.php"); ?>
                    <div class="card">
                        <div class="card-header">
                            <h4>
                                Inward Details
                                <a href="inward_add.php" class="btn btn-primary float-right">Add</a>
                            </h4>
                        </div>
                        <div class="card-body">
                            <!--<table class="table table-bordered"> -->
                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Inward Date</th>
                                        <th>Voucher No</th>
                                        <th>Ledger name</th>
                                        <th>Total Qty</th>
                                        <th>Edit</th>
                                        <th>Delete</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php
                                    $query = "SELECT t.material_id, t.voucher_no, t.voucher_date, l.LedgerName, t.total_qty
                                              FROM   materials t
                                              INNER JOIN ledgermaster l ON t.ledger_id = l.LedgerID where voucher_type='Inward' and t.isdeleted=0";
                                    $query_run = mysqli_query($con, $query);

                                    if (mysqli_num_rows($query_run) > 0) {
                                        foreach ($query_run as $mat) {
                                            ?>
                                            <tr>
                                                <td><?= $mat['material_id']; ?></td>
                                                <td><?= $mat['voucher_date']; ?></td>
                                                <td><?= $mat['voucher_no']; ?></td>
                                                <td><?= $mat['LedgerName']; ?></td>
                                                <td><?= $mat['total_qty']; ?></td>
                                              
                                                <td>
                                                    <a href="inward_edit.php?id=<?= $mat['material_id']; ?>" class="btn btn-info btn-sm">Edit</a>
                                                </td>
                                                <td>
                                                    <form action="inward_delete.php?id=<?= $mat['material_id']; ?>" method="POST">
                                                        <input type="hidden" name="material_id" value="<?= $mat['material_id']; ?>">
                                                        <button type="submit" name="btn_delete" class="btn btn-danger btn-sm">Delete</button>
                                                    </form>
                                                </td>
                                            </tr>
                                            <?php
                                        }
                                    } else {
                                        echo "<tr><td colspan='10'>No Record Found</td></tr>";
                                    }
                                    ?>
                                    
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


</div>



<?php include('includes/script.php');?>
<?php include('includes/footer.php');?>