<?php
    include('authentication.php');
    include('config/dbcon.php');

    include('includes/header.php');
    include('includes/topbar.php');
    include('includes/sidebar.php');
    
    $itemGrpQuery = "SELECT * FROM itemgroupmaster ORDER BY ItemGroupName ASC";
    $itemGrpList = mysqli_query($con,$itemGrpQuery);
    $ledgerQuery = "SELECT * FROM ledgermaster ORDER BY LedgerName ASC";
    $ledgerList = mysqli_query($con,$ledgerQuery);
    $unitQuery = "SELECT * FROM unitmaster ORDER BY UnitName ASC";
    $unitList = mysqli_query($con,$unitQuery);
?>


<!-- Modal -->
<div class="modal fade" id="ItemGroupModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5" id="exampleModalLabel">ItemGroup</h5>
        <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
      </div>

      <form action="Item_code.php" method="POST">
            <div class="modal-body">
                <div class="form group">
                    <label for="">Item Name</label>
                    <input type="text" name="ItemName" class="form-control" required>
                </div>
                <div class="form group">
                    <label for="">ItemGroup Name</label>
                    <select name="ItemGroupName" class="form-control" id="ItemGroupName">
                        <option value="">--Select Unit--</option>
                        <?php 
                        foreach($itemGrpList as $row)
                        {
                            echo '<option value="'.$row["ItemGroupID"].'">'.$row["ItemGroupName"].'</option>';
                        }
                        ?>  
                        </select>
                </div>
                <div class="form group">
                    <label for="">Item Desc</label>
                    <input type="text" name="ItemDesc" class="form-control" required>
                </div>
                <div class="form group">
                    <label for="">Unit ID</label>
                    <select name="UnitID" class="form-control" id="UnitID">
                        <option value="">--Select Unit--</option>
                        <?php 
                        foreach($unitList as $row)
                        {
                            echo '<option value="'.$row["UnitID"].'">'.$row["UnitName"].'</option>';
                        }
                        ?>  
                        </select>
                </div>
                <div class="form group">
                    <label for="">Purchase Rate</label>
                    <input type="text" name="PurchaseRate" class="form-control" required>
                </div>
                <div class="form group">
                    <label for="">Sale Rate</label>
                    <input type="text" name="SalesRate" class="form-control" required>
                </div>
                <div class="form group">
                    <label for="">Opening Qty</label>
                    <input type="text" name="OpeningQty" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Ledger Name</label>
                    <select name="LedgerID" class="form-control" id="LedgerID">
                        <option value="">--Select Customer--</option>
                        <?php 
                        foreach($ledgerList as $row)
                        {
                            echo '<option value="'.$row["LedgerID"].'">'.$row["LedgerName"].'</option>';
                        }
                        ?>  
                        </select>
                <!-- <label> <#?php echo $selectedOption ?> </label> -->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" name="Item_save" class="btn btn-primary">Save</button>
            </div>
     </form>

    </div>
  </div>
</div>

 <!-- Content Wrapper. Contains page content -->
 <div class="content-wrapper">

    <section class="content mt-4">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <?php include("message.php"); ?>
                    <div class="card">
                        <div class="card-header">
                            <h4>
                                Items
                                <!-- <a href="#" data-target="ItemGroupModal" class="btn btn-primary float-right">Add</a> -->
                                <a href="#" data-toggle="modal" data-target="#ItemGroupModal" class="btn btn-primary float-right">Add</a>
                            </h4>
                        </div>
                        <div class="card-body">
                            <!--<table class="table table-bordered"> -->
                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Item Name</th>
                                        <th>Item Group Name</th>
                                        <th>Item Desc</th>
                                        <th>Unit Name</th>
                                        <th hidden>Purchase Rate</th>
                                        <th hidden>Sales Rate</th>
                                        <th hidden>Opening Qty</th>
                                        <th hidden>Ledger Name</th>
                                        <th hidden>Created At</th>
                                        <th>Action</th>
                                    
                                    </tr>
                                </thead>
                                <tbody>
                                <!--?php 
					            //    $i = 1;
						        //    $qry = $conn->query("SELECT i.*,s.ItemGroupName as ItemGroup from `Itemmaster` i inner join ItemGroupmaster s on i.ItemGroupID = s.ItemGroupID ");
						        //    while($row = $qry->fetch_assoc()):
					            ?-->
                                    <?php
                                        $query="SELECT itemmaster.*, itemgroupmaster.ItemGroupName, unitmaster.UnitName, ledgermaster.LedgerName 
                                        FROM itemmaster 
                                        INNER JOIN itemgroupmaster ON itemmaster.ItemGroupID = itemgroupmaster.ItemGroupID 
                                        INNER JOIN unitmaster ON unitmaster.UnitID = itemmaster.UnitID
                                        INNER JOIN ledgermaster ON ledgermaster.LedgerID = itemmaster.LedgerID";
                                        $query_run=mysqli_query($con,$query);

                                        if (mysqli_num_rows($query_run)>0)
                                        {
                                         foreach($query_run as $Itemitem)
                                          {?>
                                            <tr>
                                             <td><?= $Itemitem['ItemID']; ?></td>
                                             <td><?= $Itemitem['ItemName'];?></td>
                                             <td><?= $Itemitem['ItemGroupName'];?></td>
                                             <td><?= $Itemitem['ItemDesc']?></td>
                                             <td><?= $Itemitem['UnitName']?></td>
                                             <td hidden><?= $Itemitem['PurchaseRate']?></td>
                                             <td hidden><?= $Itemitem['SalesRate']?></td>
                                             <td hidden><?= $Itemitem['OpeningQty']?></td>
                                             <td hidden><?= $Itemitem['LedgerName'];?></td>
                                             <td hidden><?= $Itemitem['CreatedAt'];?></td>
                                             <td>
                                               <form action="Item_code.php" method="POST">
                                                 <a href="Item_edit.php?Itemid=<?= $Itemitem['ItemID']; ?>" class="btn btn-info btn-sm">Edit</a>
                                                 <input type="hidden" name="Item_delete_id" value="<?= $Itemitem['ItemID']; ?>">
                                                 <button type="submit" name="Itemdelete_btn" Class="btn btn-danger btn-sm"> Delete </button>
                                                </form>
                                               </td>
                                              </tr>
                                            <?php
                                            }
                                        }
                                        else
                                        {
                                            ?>

                                                <tr>
                                                    <td colspan="11">No Record Found</td>
                                                </tr>

                                            <?php
                                        }
                                    ?>
                                    <?php ; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


</div>



<?php include('includes/script.php');?>
<?php include('includes/footer.php');?>