<?php
    include('authentication.php');
    include('config/dbcon.php');

    include('includes/header.php');
    include('includes/topbar.php');
    include('includes/sidebar.php');
?>


<!-- Modal -->
<div class="modal fade" id="ProjectModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5" id="exampleModalLabel">Project List</h5>
        <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
      </div>

      <form action="project_code.php" method="POST">
            <div class="modal-body">
                <div class="form group">
                    <label for="">Project Name</label>
                    <input type="text" name="projectname" class="form-control" required>
                </div>
                <div class="form group">
                    <label for="">Client Name</label>
                    <input type="text" name="clientname" class="form-control" required>
                </div>
                <div class="form group">
                    <label for="">Address</label>
                    <textarea name="address" class="form-control" required rows="3"></textarea>
                </div>
                <div class="form group">
                    <label for="">Mobile No</label>
                    <input type="text" name="mobileno" class="form-control" required >
                </div>
                <div class="form group">
                    <label for="">Application</label>
                    <input type="checkbox" name="windows">Windows
                    <!-- <input type="checkbox" name="website">Web site -->
                </div>
                <div class="form group">
                    <label for="">Web Site</label>
                    <input type="checkbox" name="web">Web Site
                </div>
                <div class="form group">
                    <label for="">Amount</label>
                    <input type="text" name="amount" class="form-control" required >
                </div>
                <div class="form group">
                    <label for="">AMC</label>
                    <input type="text" name="amc" class="form-control" required >
                </div>
                <div class="form group">
                    <label for="">AMC Month</label>
                    <input type="text" name="amc_month" class="form-control" required >
                </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" name="project_save" class="btn btn-primary">Save</button>
            </div>
     </form>

    </div>
  </div>
</div>

 <!-- Content Wrapper. Contains page content -->
 <div class="content-wrapper">

    <section class="content mt-4">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <?php include("message.php"); ?>
                    <div class="card">
                        <div class="card-header">
                            <h4>
                                Project List
                                <a href="#" data-toggle="modal" data-target="#ProjectModal" class="btn btn-primary float-right">Add</a>
                            </h4>
                        </div>
                        <div class="card-body">
                            <!--<table class="table table-bordered"> -->
                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Project Name</th>
                                        <th>Client Name</th>
                                        <th>Address</th>
                                        <th>Mobile No</th>
                                        <th>Windows</th>
                                        <th>Web</th>
                                        <th>Amount</th>
                                        <th>AMC</th>
                                        <th>AMC Month</th>
                                        <!-- <th>Start Date</th> -->
                                        <!-- <th>Created At</th> -->
                                        <th>Edit</th>
                                        <th>Delete</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        $query="SELECT * FROM projectmaster";
                                        $query_run=mysqli_query($con,$query);

                                        if (mysqli_num_rows($query_run)>0)
                                        {
                                            foreach($query_run as $projectitems)
                                            {
                                                //echo ;
                                                ?>
                                                    <tr>
                                                        <td><?= $projectitems['id']; ?></td>
                                                        <td><?= $projectitems['projectname']; ?></td>
                                                        <td><?= $projectitems['clientname']; ?></td>
                                                        <td><?= $projectitems['address']; ?></td>
                                                        <td><?= $projectitems['mobileno']; ?></td>
                                                        
                                                        <td>
                                                            <input type="checkbox" <?= $projectitems['windows']=='1' ? 'checked':'' ?> readonly /> 
                                                        </td>
                                                        <td>
                                                            <input type="checkbox" <?= $projectitems['web']=='1' ? 'checked':'' ?> readonly />
                                                        </td> 
                                                        <td><?= $projectitems['amount']; ?></td>
                                                        <td><?= $projectitems['amc']; ?></td>
                                                        <!-- <td><?= $projectitems['created_at']; ?></td> -->
                                                        <td><?= $projectitems['amc_month']; ?></td>
                                                        <td>
                                                            <a href="project_edit.php?id=<?= $projectitems['id']; ?>" class="btn btn-info btn-sm">Edit</a>
                                                        </td>
                                                        <td>
                                                            <form action="project_code.php" method="POST">
                                                                <input type="hidden" name="project_delete_id" value="<?= $projectitems['id']; ?>">
                                                                <button type="submit" name="project_delete_btn" Class="btn btn-danger btn-sm"> Delete </button>
                                                            </form>
                                                        </td>
                                                    </tr>
                                                <?php
                                            }

                                        }
                                        else
                                        {
                                            ?>

                                                <tr>
                                                    <td colspan="6">No Record Found</td>
                                                </tr>

                                            <?php
                                        }
                                    ?>
                                    
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


</div>



<?php include('includes/script.php');?>
<?php include('includes/footer.php');?>