<?php
    include('authentication.php');
    include('config/dbcon.php');

    include('includes/header.php');
    include('includes/topbar.php');
    include('includes/sidebar.php');
?>


<!-- Modal -->
<div class="modal fade" id="CategoryModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5" id="exampleModalLabel">Gift Category</h5>
        <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
      </div>

      <form action="category_code.php" method="POST">
            <div class="modal-body">
                <div class="form group">
                    <label for="">Category Name</label>
                    <input type="text" name="name" class="form-control" required>
                </div>
                <div class="form group">
                    <label for="">Description</label>
                    <textarea name="description" class="form-control" required rows="3"></textarea>
                </div>
                <div class="form group">
                    <label for="">Trending</label>
                    <input type="checkbox" name="trending">Trending
                </div>
                <div class="form group">
                    <label for="">Status</label>
                    <input type="checkbox" name="status">Status
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" name="category_save" class="btn btn-primary">Save</button>
            </div>
     </form>

    </div>
  </div>
</div>

 <!-- Content Wrapper. Contains page content -->
 <div class="content-wrapper">

    <section class="content mt-4">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <?php include("message.php"); ?>
                    <div class="card">
                        <div class="card-header">
                            <h4>
                                Products
                                <a href="product_add.php" class="btn btn-primary float-right">Add</a>
                            </h4>
                        </div>
                        <div class="card-body">
                            <!--<table class="table table-bordered"> -->
                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Price</th>
                                        <th>Status</th>
                                        <th>Created At</th>
                                        <th>Edit</th>
                                        <th>Delete</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        $query="SELECT * FROM itemmaster";
                                        $query_run=mysqli_query($con,$query);

                                        if (mysqli_num_rows($query_run)>0)
                                        {
                                            foreach($query_run as $prod_item)
                                            {
                                                //echo ;
                                                ?>
                                                    <tr>
                                                        <td><?= $prod_item['ItemID']; ?></td>
                                                        <td><?= $prod_item['ItemName']; ?></td>
                                                        <td><?= $prod_item['SalesRate']; ?></td>
                                                        <td>
                                                            <input type="checkbox" <?= $prod_item['LedgerID']=='1' ? 'checked':'' ?> readonly />
                                                        </td>
                                                        <td><?= $prod_item['CreatedAt']; ?></td>
                                                        <td>
                                                            <a href="product_edit.php?prod_id=<?= $prod_item['ItemID']; ?>" class="btn btn-info btn-sm">Edit</a>
                                                        </td>
                                                        <td>
                                                         

                                                            <form action="product_code.php" method="POST">
                                                                <input type="hidden" name="prod_delete_id" value="<?= $prod_item['ItemID']; ?>">
                                                                <button type="submit" name="prod_delete_btn" Class="btn btn-danger btn-sm"> Delete </button>
                                                            </form>
                                                        </td>
                                                       
                                                    </tr>
                                                <?php
                                            }

                                        }
                                        else
                                        {
                                            ?>

                                                <tr>
                                                    <td colspan="6">No Record Found</td>
                                                </tr>

                                            <?php
                                        }
                                    ?>
                                    
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


</div>



<?php include('includes/script.php');?>
<?php include('includes/footer.php');?>