<?php
    include('authentication.php');
    include('config/dbcon.php');

    include('includes/header.php');
    include('includes/topbar.php');
    include('includes/sidebar.php');

    if (isset($_SESSION['auth']))
    {
      $loggedUserID = $_SESSION['auth_user']['user_id'];
      $loggedUserName = $_SESSION['auth_user']['user_name'];
    }
    else
    {
      echo "Not Logged in";
    }

    $maxOrderQuery = "SELECT MAX(MaxID) AS maxOrderId FROM ordermaster";
    $maxOrderIdResult = mysqli_query($con,$maxOrderQuery);
    
    if ($maxOrderIdResult->num_rows > 0) {
        // Fetch the result as an associative array
        $maxOrderRow = $maxOrderIdResult->fetch_assoc();
        // Get the maximum orderId value
        $maxOrderId = $maxOrderRow["maxOrderId"];
        echo $maxOrderId;
    } else {
        // If no results are found
        $maxOrderId = "ord-1";
    }

    $ledgerQuery = "SELECT * FROM ledgermaster ORDER BY LedgerName ASC";
    $ledgerList = mysqli_query($con,$ledgerQuery);

    $itemQuery = "SELECT * FROM itemmaster ORDER BY ItemName ASC";
    $itemList = mysqli_query($con,$itemQuery);

    $sizeQuery = "SELECT * FROM sizemaster ORDER BY SizeName ASC";
    $sizeList = mysqli_query($con,$sizeQuery);

    $gradeQuery = "SELECT * FROM grademaster ORDER BY GradeName ASC";
    $gradeList = mysqli_query($con,$gradeQuery);
?>

 <!-- Content Wrapper. Contains page content -->
 <div class="content-wrapper">
 <?php
 if(isset($_GET['ord_id']))
    {
        $orderId=$_GET['ord_id'];
        $query="SELECT * FROM ordermaster where OrderId='$orderId'";
        $query_run=mysqli_query($con,$query);

        if(mysqli_num_rows($query_run)>0)
        {
            
            $orderDetails=mysqli_fetch_array($query_run);
            $oderItemsQuery = "SELECT * FROM customerorders where OrderId='$orderId'";
            $orderList = mysqli_query($con,$oderItemsQuery);
            foreach($ledgerList as $row)
            {
                if($row['LedgerID'] == $orderDetails['LedgerID'] ){
                    $gstNo = $row['GSTNo'];
                    $mobNo = $row['MbNo']; 
                    $address = $row['Address'];
                }
              
            }
            // $categoryid=$proditem['categoryid'];
        ?>
  <section class="content mt-4">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <?php include("message.php"); ?>
                <div class="card">
                    <div class="card-header">
                        <h4>
                            Order - Edit
                            <a href="order.php" class="btn btn-danger float-right">Back</a>
                        </h4>
                    </div>
                    <div class="card-body">  
                        <form action="order_code.php" method="POST" enctype="multipart/form-data">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                         <input type="hidden" name="orderID" value="<?= $orderDetails['OrderID'] ?>">
                                        <label>Order Number</label>
                                        <input type="text" name="orderNumber" class="form-control" placeholder="Enter order number" id="orderNumber" readonly value=<?= $orderDetails["OrderNo"]?>>
                                        <input type="text" name="maxID" class="form-control" placeholder="Enter order number" id="maxID" readonly value=<?= $orderDetails["OrderNo"] ?> hidden="true">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Order Date</label>
                                        <input type="date" name="orderDate" id="orderDate" class="form-control" placeholder="Enter customer person name" value=<?= $orderDetails["OrderDate"] ?>>
                                    </div>
                                </div>
                             <!-- </div>   -->
                             <!-- <div class="row"> -->
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Customer Name</label>
                                        <select name="customer_name" class="form-control" id="customer_name" onchange="getCutomerDetails()">
                                            <option value="">--Select Customer--</option>
                                            <?php 
                                            foreach($ledgerList as $row)
                                            {
                                                $selected = ($orderDetails['LedgerID'] == $row["LedgerID"]) ? 'selected="selected"' : '';
                                                echo '<option value="'.$row["LedgerID"].'" '.$selected.'>'.$row["LedgerName"].'</option>';
                                            }
                                            ?>  
                                         </select>
                                   <!-- <label> <#?php echo $selectedOption ?> </label> -->
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>GST Number</label>
                                        <input type="text" name="gstNo" class="form-control" id="gstNo" value=<?= $gstNo ?> readonly>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Mobile Number</label>
                                        <input type="text" name="mobile" id="mobile" class="form-control" value=<?= $mobNo ?> readonly>
                                    </div>
                                </div> 
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Address</label>
                                        <input type="text" name="address" id="address" class="form-control" value=<?= $address ?> readonly>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Customer Person Name</label>
                                        <input type="text" name="customerPerson" id="customerPerson" value=<?= $orderDetails['ContactPersonName']?> class="form-control" placeholder="Enter customer person name">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Sales person name</label>
                                        <input type="text" name="salesPerson" id="salesPerson" class="form-control" value="<?= $loggedUserName ?>" readonly>
                                        <input type="text" name="salesPersonID" id="salesPersonID" class="form-control" value="<?= $loggedUserID ?>" readonly hidden>
                                    </div>
                                </div>
                                <div class="form-group col-4">
                                        <label>Order Type</label>
                                        <?php 
                                            $selectedNew = ($orderDetails['OrderType'] == 'new') ? 'selected="selected"' : '';
                                            $selectedResharp = ($orderDetails['OrderType'] == 'resharpning') ? 'selected="selected"' : '';
                                        ?>
                                        <select name="order_type" class="form-control" id="order_type">
                                            <option value="">--Select Order Type--</option>
                                            <option value="new" <?= $selectedNew?>>New</option>
                                            <option value="resharpning" <?= $selectedResharp?>>Resharpning</option>
                                         </select>
                                    </div>
                                <div class="card-header col-md-12">
                                <hr/>
                                    <h4>Add Item</h4>
                                </div>
                                <div class="row">
                                    <div class="form-group col-5">
                                        <label>Item Name</label>
                                        <select name="item_name" class="form-control" id="item_name">
                                            <option value="">--Select Item--</option>
                                            <?php 
                                            foreach($itemList as $row)
                                            {
                                                echo '<option value="'.$row["ItemID"].'">'.$row["ItemName"].'</option>';
                                            }
                                            ?>  
                                         </select>
                                    </div>
                                    <div class="form-group col-5">
                                        <label>Item Size</label>
                                        <select name="item_size" class="form-control" id="item_size">
                                            <option value="">--Select Item Size--</option>
                                            <?php 
                                            foreach($sizeList as $row)
                                            {
                                                echo '<option value="'.$row["SizeID"].'">'.$row["SizeName"].'</option>';
                                            }
                                            ?>  
                                         </select>
                                    </div>
                                    <div class="form-group col-5">
                                        <label>Grade</label>
                                        <select name="item_grade" class="form-control" id="item_grade">
                                            <option value="">--Select Grade--</option>
                                            <?php 
                                            foreach($gradeList as $row)
                                            {
                                                echo '<option value="'.$row["GradeID"].'">'.$row["GradeName"].'</option>';
                                            }
                                            ?>  
                                         </select>
                                    </div>
                                    <div class="form-group col-5">
                                        <label>Item Quantity</label>
                                        <input type="number" name="item_qty" class="form-control" placeholder="Enter item quantity" id="item_qty">
                                    </div>
                                    <div class="form-group col-2 align-self-end">
                                            <button type="button" name="add_item" class="btn btn-primary btn-block" onclick="addItem()">Add</Button>
                                    </div>
                                </div>
                                <div class="form-group col-12 align-self-end">
                                    <table id="itemsTable" class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th>Item Name</th>
                                                <th>Item Size</th>
                                                <th>Item Grade</th>
                                                <th>Item Quantity</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- Added items will be displayed here -->
                                            <?php
                                              foreach($orderList as $rowIndex => $row)
                                               {?>
                                               <tr>
                                                <td><?= $row['ItemName']?></td>
                                                <td><?= $row['GradeName']?></td>
                                                <td><?= $row['SizeName']?></td>
                                                <td><?= $row['OrderQty']?></td>
                                                <td><input type='button' value='Remove' class='btn btn-danger btn-sm' onclick='removeItem(<?=$rowIndex?>)'/></td>
                                                <td hidden><input type='text' id='itemNameID' name='itemNameID[]' value=<?=$row['ItemID']?> required></input></td>
                                                <td hidden><input type='text' id='itemSizeID' name='itemSizeID[]' value=<?=$row['SizeID']?> required></input></td>
                                                <td hidden><input type='text' id='itemGradeID' name='itemGradeID[]' value=<?=$row['GradeID']?> required></input></td>
                                                <td hidden><input type='text' id='itemQty' name='itemQty[]' value=<?=$row['OrderQty']?> required></input></td>
                                               </tr>
                                             <?php }
                                            ?>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td></td>
                                                <td colspan="2"></td>
                                                <td>
                                                    <label>Total Qty:</label> 
                                                    <span id="totalQty"><?=$orderDetails['TotalOrderQty']?></span>
                                                    <input type="text" name="inpTotalQty" id="inpTotalQty" class="form-control" hidden>
                                                </td>
                                                <td></td>
                                                <td></td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Click To Save</label><br>
                                        <button type="submit" name="order_update" class="btn btn-primary btn-block">Save</Button>
                                    </div>
                                </div> 
                            </div>
                        </form>                       
                    </div>
                </div>

            </div>
        </div>
    </div>
  </section>
  <?php
        }
        else
        {
            echo "No records found";
        }
    }
  ?>
</div>

<?php include('includes/script.php');?>
<?php include('includes/footer.php');?>
<script type="text/javascript" src="assets/dist/js/pages/add_order.js"></script>
