$(document).ready(function () {
    $('.details-button').click(function () {
        var orderId = $(this).data('order-id');
        $.ajax({
            url: 'order_code.php',
            type: 'GET',
            data: {ord_id: orderId},
            success: function (response) {
                $('#orderDetailsTbody').html(response);
            }
        });
    });
});

function getCutomerDetails() {
    const select = document.getElementById("customer_name");
    if(select){
        const resultInput = document.getElementById("result");
        const selectedCustomerId = select.options[select.selectedIndex].value;
        var xhr = new XMLHttpRequest();
        xhr.onreadystatechange = function() {
        if (xhr.readyState == 4 && xhr.status == 200) {
            var customerDetails = JSON.parse(xhr.responseText);
            if(customerDetails){
                if(customerDetails?.Address) document.getElementById('address').value = customerDetails.Address;
                if(customerDetails?.MbNo) document.getElementById('mobile').value = customerDetails.MbNo;
                if(customerDetails?.GSTNo) document.getElementById('gstNo').value = customerDetails.GSTNo;
            }
         }
        };
     xhr.open('GET', 'order_code.php?customerId=' + selectedCustomerId, true);
     xhr.send();
    }
}

function addItem() {
    var itemNameHtml = document.getElementById('item_name');
    var itemName = itemNameHtml.options[itemNameHtml.selectedIndex].text;
    var itemNameId = itemNameHtml.value;
    
    var itemSizeHtml = document.getElementById('item_size');
    var itemSize = itemSizeHtml.options[itemSizeHtml.selectedIndex].text;
    var itemSizeId = itemSizeHtml.value;
    var itemGradeHtml = document.getElementById('item_grade');
    var itemGrade = itemGradeHtml.options[itemGradeHtml.selectedIndex].text;
    var itemGradeId = itemGradeHtml.value;
    var itemQty = document.getElementById('item_qty').value;
    if (itemNameId && itemSizeId && itemGradeId && itemQty) {
        var tableBody = document.getElementById('itemsTable').getElementsByTagName('tbody')[0];
        var newRow = tableBody.insertRow(tableBody.rows.length);

        var cell1 = newRow.insertCell(0);
        var cell2 = newRow.insertCell(1);
        var cell3 = newRow.insertCell(2);
        var cell4 = newRow.insertCell(3);
        var cell5 = newRow.insertCell(4);
        var cell6 = newRow.insertCell(5);
        var cell7 = newRow.insertCell(6);
        var cell8 = newRow.insertCell(7);
        var cell9 = newRow.insertCell(8);


        cell6.id = 'itemNameId';
        cell6.hidden = true;
        cell7.id = 'itemSizeId';
        cell7.hidden = true;
        cell8.id = 'itemGradeId';
        cell8.hidden = true;
        cell9.id = 'itemQty';
        cell9.hidden = true;
        
        cell1.innerHTML = itemName;
        cell2.innerHTML = itemSize;
        cell3.innerHTML = itemGrade;
        cell4.innerHTML = itemQty;
        cell5.innerHTML = "<input type='button' value='Remove' class='btn btn-danger btn-sm'/>"
        cell6.innerHTML = "<input type='text' name='itemNameID[]' value={"+itemNameId+"} required></input>";
        cell7.innerHTML = "<input type='text' name='itemSizeID[]' value={"+itemSizeId+"} required></input>";
        cell8.innerHTML = "<input type='text' name='itemGradeID[]' value={"+itemGradeId+"} required></input>";
        cell9.innerHTML = "<input type='text' name='itemQty[]' value={"+itemQty+"} required></input>";

        cell5.onclick = function() {
            var rowIndex = newRow.rowIndex;
            console.log('rowIndex', rowIndex);
            calculateTotalQty(tableBody.rows[rowIndex].cells[3].innerHTML, 'remove');
            tableBody.deleteRow(rowIndex);
     };
        calculateTotalQty(itemQty);
        // Clear input fields
        document.getElementById('item_name').value = '';
        document.getElementById('item_size').value = '';
        document.getElementById('item_grade').value = '';
        document.getElementById('item_qty').value = '';
    } else {
        alert("Please fill in all fields before adding an item.");
    }
}

function removeItem(rowIndex){
    var tableBody = document.getElementById('itemsTable').getElementsByTagName('tbody')[0];
    // var rowIndex = newRow.rowIndex;
    console.log('rowIndex', rowIndex);
    calculateTotalQty(tableBody.rows[rowIndex].cells[3].innerHTML, 'remove');
    tableBody.deleteRow(rowIndex);
}

function calculateTotalQty(itemQty, flag='add') {
    console.log('itemQty', itemQty);
    var currentTotal = parseInt(document.getElementById("totalQty").textContent);
    var totalQty = currentTotal;
    if(itemQty && flag === 'add'){
        totalQty += parseInt(itemQty);
    }else{
        totalQty -= parseInt(itemQty);
    }
    console.log('totalQty', totalQty);

    document.getElementById("totalQty").innerHTML = totalQty;
    document.getElementById("inpTotalQty").value = totalQty;
}
